/* All user scripts should derive from the base "Application" class */

require ("Application");


/* Applications share the execution thread and the global name
 * space, so we create a class that contains all of the functions
 * and variables for the application.  This does two things:
 *   1) creates a private name space for the application, and
 *   2) allows you to re-load the application to create either
 *      a new unique instance or multiple instances without
 *      damaging an existing running instance.
 */
class BridgeCreator Application
{
	//these two tags hold the column position of the server and internal tags in the CSV file
	serverTagPos;
	internalTagPos;
	
	//this tag is our File Pointer once the file is opened
	fp;
}

method BridgeCreator.readFile()
{
	//we open the file here.  If you want to change the path of where the file is you would do that here.
	if ((fp = open("C:\\Program Files (x86)\\Cogent\\Cogent DataHub\\scripts\\DataHubBridges.csv", "r", nil)) != nil);
	{
		//create some local variables 
		local line;
		
		local count = 0;
		
		//loop until we have read the entire file.
		while((line = read_line(fp)) != _eof_)
		{
			//if we are at the beginning of the file we want to skip of the header and read the second line.
			if(count == 0)
			{
				line = read_line(fp);
				count++;
			}
			
			//add variables to hold the two tags we are bridging
			local sourceTag;
			local destTag;
			local scale;
			local multiply;
			local add;
			
			//split the comma separated line we read in and place it into an array
			lineArray = list_to_array(string_split(line, ",", 0));
				
			//set the tag name from the Server
			sourceTag = lineArray[sourceTagPos];
			
			//set the tag name for the internal OPC DataHub tag
			destTag = lineArray[destTagPos];
			
			scale = lineArray[2];
			multiply = lineArray[3];
			add = lineArray[4];
			
			
				//set the value that will we written back to the tag after the bridge is created
				local tagValue = eval(symbol(sourceTag));
			
				//bridge the two tags.  This will create the internal tag if it does not exist.
				//use flag 258 for Inverse Only, use flag 259 for Bi-directional and 257 for Forward Only
				datahub_command(format("(bridge \"%s\" \"%s\" 259)", sourceTag, destTag));
			
				//write the original value back to the bridged tag.
				datahub_write(sourceTag, tagValue);
			}
		
		//once we have read the entire file we need to close the file.
		close(fp);
	}
	
}


/* The constructor will start when the script is loaded. */
method BridgeCreator.constructor ()
{
	//Set the column position within the CSV file of the server and internal tags.
	//If the format of the CSV file changes these values may also need to change.
	sourceTagPos = 0;
	destTagPos = 1;
	
	//enable point-to-point bridging in the case that this is disabled.
	datahub_command("(enable_bridging 1)");
	
	//call the readFile() method that will read the file and create all the bridges.
	.readFile();
	
}

/* Any code to be run when the program gets shut down. */
method BridgeCreator.destructor ()
{
}

/* Start the program by instantiating the class.  If your
 * constructor code does not create a persistent reference to
 * the instance (self), then it will be destroyed by the
 * garbage collector soon after creation.  If you do not want
 * this to happen, assign the instance to a global variable, or
 * create a static data member in your class to which you assign
 * 'self' during the construction process.  ApplicationSingleton()
 * does this for you automatically. */
ApplicationSingleton (BridgeCreator);
